﻿using System;
using System.Diagnostics;
using System.IO;

namespace MicroRWD.Common
{
    // Logging services
    public static class Log
    {
        #region Private Constants

        // Source for trace messages
        private static TraceSource mySource = new TraceSource("MicroRWD");

        #endregion


        #region Public Methods

        // Add listeners to support an error and a debug file as output
        public static void AddListeners(string LogPath)
        {
            mySource.Listeners.Add(new TextWriterTraceListener(LogPath + "error.log", "errorListener"));
            mySource.Listeners["errorListener"].Filter = new System.Diagnostics.EventTypeFilter(SourceLevels.Error);
#if DEBUG
            mySource.Listeners.Add(new TextWriterTraceListener(LogPath + "debug.log", "debugListener"));
            mySource.Listeners["debugListener"].Filter = new System.Diagnostics.EventTypeFilter(SourceLevels.All);
#endif
        }

        // Publish an error message
        public static void Error(string _message)
        {
            mySource.TraceEvent(TraceEventType.Error, 0, Format(_message));
        }

        // Publish a warning message
        public static void Warning(string _message)
        {
            mySource.TraceEvent(TraceEventType.Warning, 0, Format(_message));
        }

        // Publish an information message
        public static void Information(string _message)
        {
            mySource.TraceEvent(TraceEventType.Information, 0, Format(_message));
        }

        #endregion


        #region Private Methods

        // Format a message string with a timestamp and context (stack frame) information
        private static string Format(string _message)
        {
            string result = "";
            try
            {
                StackTrace stackTrace = new StackTrace();
                StackFrame[] stackFrames = stackTrace.GetFrames();
                StackFrame sf = stackFrames[2];
                result = DateTime.UtcNow.ToString("yyyyMMddHHmmss.fff") + " : ";
                result += sf.GetMethod().DeclaringType.Name + " : " + sf.GetMethod().ToString() + " : ";
                result += _message;
            }
            catch (Exception)
            {
                result = _message;
            }
            return result;
        }

        #endregion
    }
}
